/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.MultilevelModifierRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class MultilevelModifierRecipeBuilder
extends AbstractRecipeBuilder<MultilevelModifierRecipeBuilder> {
    private final ModifierId result;
    private final List<MultilevelModifierRecipe.LevelEntry> levels = new ArrayList<MultilevelModifierRecipe.LevelEntry>();
    private final List<SizedIngredient> inputs = new ArrayList<SizedIngredient>();
    private boolean allowCrystal = true;
    private class_1856 tools = class_1856.field_9017;
    private int maxToolSize = 16;
    private ModifierMatch requirements = ModifierMatch.ALWAYS;
    private String requirementsError = "";

    public MultilevelModifierRecipeBuilder setTools(class_1856 tools, int maxSize) {
        this.tools = tools;
        this.maxToolSize = maxSize;
        return this;
    }

    public MultilevelModifierRecipeBuilder setTools(class_1856 tools) {
        return this.setTools(tools, 16);
    }

    public MultilevelModifierRecipeBuilder setTools(class_6862<class_1792> tag) {
        return this.setTools(class_1856.method_8106(tag));
    }

    public MultilevelModifierRecipeBuilder addInput(SizedIngredient ingredient) {
        this.inputs.add(ingredient);
        return this;
    }

    public MultilevelModifierRecipeBuilder addInput(class_1856 ingredient) {
        return this.addInput(SizedIngredient.of(ingredient));
    }

    public MultilevelModifierRecipeBuilder addInput(class_1935 item, int amount) {
        return this.addInput(SizedIngredient.fromItems(amount, item));
    }

    public MultilevelModifierRecipeBuilder addInput(class_1935 item) {
        return this.addInput(item, 1);
    }

    public MultilevelModifierRecipeBuilder addInput(class_6862<class_1792> tag, int amount) {
        return this.addInput(SizedIngredient.fromTag(tag, amount));
    }

    public MultilevelModifierRecipeBuilder addInput(class_6862<class_1792> tag) {
        return this.addInput(tag, 1);
    }

    public MultilevelModifierRecipeBuilder allowCrystal() {
        this.allowCrystal = true;
        return this;
    }

    public MultilevelModifierRecipeBuilder disallowCrystal() {
        this.allowCrystal = false;
        return this;
    }

    public MultilevelModifierRecipeBuilder setRequirements(ModifierMatch requirements) {
        this.requirements = requirements;
        return this;
    }

    public MultilevelModifierRecipeBuilder setRequirementsError(String requirementsError) {
        this.requirementsError = requirementsError;
        return this;
    }

    private MultilevelModifierRecipeBuilder addLevelRange(@Nullable SlotType.SlotCount slots, int minLevel, int maxLevel) {
        if (minLevel > maxLevel) {
            throw new JsonSyntaxException("minLevel must be less than or equal to maxLevel");
        }
        if (!this.levels.isEmpty() && minLevel <= this.levels.get(this.levels.size() - 1).maxLevel()) {
            throw new JsonSyntaxException("Level range must be greater than previous range");
        }
        this.levels.add(new MultilevelModifierRecipe.LevelEntry(slots, minLevel, maxLevel));
        return this;
    }

    public MultilevelModifierRecipeBuilder addLevelRange(SlotType slot, int slotCount, int minLevel, int maxLevel) {
        return this.addLevelRange(new SlotType.SlotCount(slot, slotCount), minLevel, maxLevel);
    }

    public MultilevelModifierRecipeBuilder addLevel(SlotType slot, int slotCount, int level) {
        return this.addLevelRange(slot, slotCount, level, level);
    }

    public MultilevelModifierRecipeBuilder addMinLevel(SlotType slot, int slotCount, int level) {
        return this.addLevelRange(slot, slotCount, level, Short.MAX_VALUE);
    }

    public MultilevelModifierRecipeBuilder addLevelRange(int minLevel, int maxLevel) {
        return this.addLevelRange(null, minLevel, maxLevel);
    }

    public MultilevelModifierRecipeBuilder addLevel(int level) {
        return this.addLevelRange(level, level);
    }

    public MultilevelModifierRecipeBuilder addMinLevel(int level) {
        return this.addLevelRange(level, Short.MAX_VALUE);
    }

    public MultilevelModifierRecipeBuilder saveSalvage(Consumer<class_2444> consumer, class_2960 id) {
        if (this.levels.isEmpty()) {
            throw new IllegalStateException("Must have at least 1 level");
        }
        for (MultilevelModifierRecipe.LevelEntry levelEntry : this.levels) {
            if (levelEntry.slots() == null) continue;
            consumer.accept(new FinishedSalvage(new class_2960(id.method_12836(), id.method_12832() + "_level_" + levelEntry.minLevel()), levelEntry.slots(), levelEntry.minLevel(), levelEntry.maxLevel()));
        }
        return this;
    }

    @Override
    public void save(Consumer<class_2444> consumerIn) {
        this.save(consumerIn, this.result);
    }

    @Override
    public void save(Consumer<class_2444> consumer, class_2960 id) {
        if (this.inputs.isEmpty() && !this.allowCrystal) {
            throw new IllegalStateException("Must either have at least 1 input or allow crystal");
        }
        if (this.levels.isEmpty()) {
            throw new IllegalStateException("Must have at least 1 level");
        }
        if (!this.inputs.isEmpty() && this.requirementsError.isEmpty() && this.levels.size() > 1) {
            throw new IllegalStateException("Must set requirements error if inputs are set");
        }
        class_2960 advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept(new FinishedAdding(id, advancementId));
    }

    private void writeCommon(JsonObject json) {
        class_1856 ingredient = this.tools;
        if (this.tools == class_1856.field_9017) {
            ingredient = class_1856.method_8106(TinkerTags.Items.MODIFIABLE);
        }
        json.add("tools", ingredient.method_8089());
        if (this.maxToolSize != 16) {
            json.addProperty("max_tool_size", (Number)this.maxToolSize);
        }
    }

    private MultilevelModifierRecipeBuilder(ModifierId result) {
        this.result = result;
    }

    public static MultilevelModifierRecipeBuilder modifier(ModifierId result) {
        return new MultilevelModifierRecipeBuilder(result);
    }

    private class FinishedSalvage
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        private final SlotType.SlotCount slots;
        private final int minLevel;
        private final int maxLevel;

        public FinishedSalvage(class_2960 id, SlotType.SlotCount slots, int minLevel, int maxLevel) {
            super(id, null);
            this.slots = slots;
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
        }

        public void method_10416(JsonObject json) {
            MultilevelModifierRecipeBuilder.this.writeCommon(json);
            JsonObject slotJson = new JsonObject();
            slotJson.addProperty(this.slots.getType().getName(), (Number)this.slots.getCount());
            json.add("slots", (JsonElement)slotJson);
            json.addProperty("modifier", MultilevelModifierRecipeBuilder.this.result.toString());
            json.addProperty("min_level", (Number)this.minLevel);
            if (this.maxLevel != Short.MAX_VALUE) {
                json.addProperty("max_level", (Number)this.maxLevel);
            }
        }

        public class_1865<?> method_17800() {
            return (class_1865)TinkerModifiers.modifierSalvageSerializer.get();
        }
    }

    private class FinishedAdding
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public FinishedAdding(@Nullable class_2960 id, class_2960 advancementId) {
            super(id, advancementId);
        }

        public void method_10416(JsonObject json) {
            if (!MultilevelModifierRecipeBuilder.this.inputs.isEmpty()) {
                JsonArray array = new JsonArray();
                for (SizedIngredient ingredient : MultilevelModifierRecipeBuilder.this.inputs) {
                    array.add((JsonElement)ingredient.serialize());
                }
                json.add("inputs", (JsonElement)array);
            }
            json.addProperty("allow_crystal", Boolean.valueOf(MultilevelModifierRecipeBuilder.this.allowCrystal));
            MultilevelModifierRecipeBuilder.this.writeCommon(json);
            if (MultilevelModifierRecipeBuilder.this.requirements != ModifierMatch.ALWAYS) {
                JsonObject reqJson = MultilevelModifierRecipeBuilder.this.requirements.serialize();
                reqJson.addProperty("error", MultilevelModifierRecipeBuilder.this.requirementsError);
                json.add("requirements", (JsonElement)reqJson);
            } else if (!MultilevelModifierRecipeBuilder.this.requirementsError.isEmpty()) {
                json.addProperty("level_error", MultilevelModifierRecipeBuilder.this.requirementsError);
            }
            JsonArray levelArray = new JsonArray();
            for (MultilevelModifierRecipe.LevelEntry levelEntry : MultilevelModifierRecipeBuilder.this.levels) {
                levelArray.add((JsonElement)levelEntry.serialize());
            }
            json.add("levels", (JsonElement)levelArray);
            json.addProperty("result", MultilevelModifierRecipeBuilder.this.result.toString());
        }

        public class_1865<?> method_17800() {
            return (class_1865)TinkerModifiers.multilevelModifierSerializer.get();
        }
    }
}

